--Legal Notice: (C)2007 Altera Corporation. All rights reserved.  Your
--use of Altera Corporation's design tools, logic functions and other
--software and tools, and its AMPP partner logic functions, and any
--output files any of the foregoing (including device programming or
--simulation files), and any associated documentation or information are
--expressly subject to the terms and conditions of the Altera Program
--License Subscription Agreement or other applicable license agreement,
--including, without limitation, that your use is for the sole purpose
--of programming logic devices manufactured by Altera and sold by Altera
--or its authorized distributors.  Please refer to the applicable
--agreement for further details.


-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity raster is 
        port (
              -- inputs:
                 signal address : IN STD_LOGIC_VECTOR (4 DOWNTO 0);
                 signal chipselect : IN STD_LOGIC;
                 signal clk : IN STD_LOGIC;
                 signal read : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal write : IN STD_LOGIC;
                 signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- outputs:
                 
                 signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);


				signal VGA_CLK : OUT STD_LOGIC;                         -- Clock
				signal VGA_HS  : OUT STD_LOGIC;                          -- H_SYNC
				signal VGA_VS : OUT STD_LOGIC;                          -- V_SYNC
				signal VGA_BLANK : OUT STD_LOGIC;                       -- BLANK
				signal VGA_SYNC : OUT STD_LOGIC;					-- SYNC
				signal VGA_R : out unsigned(9 downto 0);                           -- Red[9:0]
				signal VGA_G : out unsigned(9 downto 0);                          -- Green[9:0]
				signal VGA_B : out unsigned(9 downto 0) -- Blue[9:0]
              );
end entity raster;


architecture europa of raster is
component de2_vga_raster is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (4 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal reset : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                     signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);


				signal VGA_CLK : OUT STD_LOGIC;                         -- Clock
				signal VGA_HS  : OUT STD_LOGIC;                          -- H_SYNC
				signal VGA_VS : OUT STD_LOGIC;                          -- V_SYNC
				signal VGA_BLANK : OUT STD_LOGIC;                       -- BLANK
				signal VGA_SYNC : OUT STD_LOGIC;					-- SYNC
				signal VGA_R : out unsigned(9 downto 0);                           -- Red[9:0]
				signal VGA_G : out unsigned(9 downto 0);                          -- Green[9:0]
				signal VGA_B : out unsigned(9 downto 0) -- Blue[9:0]
                 );
end component de2_vga_raster;

               

				signal internal_readdata : STD_LOGIC_VECTOR (15 DOWNTO 0);
				signal internal_VGA_CLK : STD_LOGIC;                         -- Clock
				signal internal_VGA_HS  : STD_LOGIC;                          -- H_SYNC
				signal internal_VGA_VS : STD_LOGIC;                          -- V_SYNC
				signal internal_VGA_BLANK : STD_LOGIC;                       -- BLANK
				signal internal_VGA_SYNC : STD_LOGIC;					-- SYNC
				signal internal_VGA_R : unsigned(9 downto 0);                           -- Red[9:0]
				signal internal_VGA_G : unsigned(9 downto 0);                          -- Green[9:0]
				signal internal_VGA_B : unsigned(9 downto 0);

begin

  --the_de2_led_flasher, which is an e_instance
  the_de2_vga_raster : de2_vga_raster
    port map(
      
		
	  VGA_CLK => internal_VGA_CLK,
	  VGA_HS => internal_VGA_HS,
      VGA_VS => internal_VGA_VS,
	  VGA_BLANK => internal_VGA_BLANK,
	  VGA_SYNC => internal_VGA_SYNC,	
	  VGA_R => internal_VGA_R,
	  VGA_G => internal_VGA_G,
	  VGA_B => internal_VGA_B,	
	
      readdata => internal_readdata,
      address => address,
      chipselect => chipselect,
      clk => clk,
      read => read,
      reset => reset,
      write => write,
      writedata => writedata
    );


  --vhdl renameroo for output signals
 
VGA_CLK <= internal_VGA_CLK;
	  VGA_HS <= internal_VGA_HS;
      VGA_VS <= internal_VGA_VS;
	  VGA_BLANK <= internal_VGA_BLANK;
	  VGA_SYNC <= internal_VGA_SYNC;
	  VGA_R <= internal_VGA_R;
	  VGA_G <= internal_VGA_G;
	  VGA_B <= internal_VGA_B;
  --vhdl renameroo for output signals
  readdata <= internal_readdata;

end europa;

